%This function uses C++ implementation of the median filter

function [img_in img_out] = binary_segment(image)


    if (size(image,3)~=1)
        image=rgb2gray(image);
    end;

    B = double(fast_medfilt(uint8(image*255),13))/255.0;

    level = graythresh(B);
    BW = im2bw(B,level);

    img_in = image.*(1-BW);
    CC = bwconncomp(img_in,8);
    numPixels = cellfun(@numel,CC.PixelIdxList);
    [biggest,idx] = max(numPixels);
    img_in = zeros(size(image));
    img_in(CC.PixelIdxList{idx})=image(CC.PixelIdxList{idx});
    img_out = image - img_in;

	clearvars -except img_in img_out image
    
end
